-- AG: 06.06.06
--    triggers.lua
--     Humans[id].patrol_routine (  triggers.lua)
--  :
-- { pts = path1, size = 4, mode = "run", style = "circle", dir = 1, direction = 1, wait_style = "each", wait_time = 5 }
-- pts -     -   
-- size -    -   
-- mode -   -     (run, walk, sneak, crawl, move)
-- style -  :
-- 		circle	-  -  -> , ABCA (         ,    )
--		line	- "  " -  -> , ABCBA
--		once	-  -      ,        , ABC
--		random	-      , BACDFABE
-- dir -  ,  1 -  ,  -1 -   (  = 1,    )
-- direction -   
-- wait_style -    :
--		none			-  
--		each			-    
--		last			-   
--		first_and_last	-      
--		first			-   
--		random			-    
-- wait_time -    

b_patrol = 
{
----------------------------
--SOLDIER PATROL BEHAVIOR--
----------------------------
	think = function(id, time, strategy)
calls.enter("b_patrol.think",id)
		log(id, " ")
		local human 		= Humans[id]
		local x,y,z,f 		= getPosition(id)
		local dist		= 0
		local point 		= Humans[id].patrol_status
		local last_point	= point
		local patrol_routine 	= Triggers[Humans[id].patrol_routine]
		local path = 	
		{ 
			pts 		= deepcopy(patrol_routine.patrol_points),
			style 		= patrol_routine.patrol_type,
			size 		= patrol_routine.point_count,
			dir 		= patrol_routine.line_dir,
			mode 		= patrol_routine.transfer_mode,
			wait_style 	= patrol_routine.wait_style,
			wait_time 	= patrol_routine.wait_time,
			direction 	= patrol_routine.direction,
			radius		= patrol_routine.point_radius
		}
-----------------------------------------------------------------------------------------------------------
		x = path.pts[point].x
		y = path.pts[point].y
		z = path.pts[point].z

		if((path.radius > 0.5) and isValid(Humans[id].app)) then
			dist = service.person2point_distance(id, Humans[id].app.x, Humans[id].app.y, Humans[id].app.z)
		else
			dist = service.person2point_distance(id, x, y, z)
		end
-----------------------------------------------------------------------------------------------------------
		if ((path.wait_style ~= "none") and (Humans[id].wait_start == -1) and (Humans[id].waited == false)) then
			Humans[id].wait_elapsed = 0

			if (path.wait_style == "each") then
				Humans[id].wait_start = time
				log(id, "   .  :", path.wait_time)
			elseif (path.wait_style == "last") then

				if (last_point == path.size) then
					Humans[id].wait_start = time
					log(id, "   .  :", path.wait_time)
				end

			elseif (path.wait_style == "first") then

				if (last_point == 1) then
					Humans[id].wait_start = time
					log(id, "   .  :", path.wait_time)
				end

			elseif (path.wait_style == "first_and_last") then

				if ((last_point == path.size) or (last_point == 1)) then
					Humans[id].wait_start = time
					log(id, "     . :", last_point, " :", path.wait_time)
				end

			elseif (path.wait_style == "random") then

				if (math.random() > 0.5) then
					Humans[id].wait_start = time
					log(id, "   . :", last_point, " :", path.wait_time)
				end

			end

		end
-----------------------------------------------------------------------------------------------------------
		if ((dist < 2) and ((path.wait_style == "none") or (Humans[id].wait_start == -1))) then
			log(id, "   ", point, "  .")

			if (path.style == "random") then
				point = math.random(path.size)
			elseif (path.style == "circle") then
				point = point + path.dir

				if (point > path.size) then
					log(id, "    -   ")
					point = 1
				end

			elseif (path.style == "line") then
				point = point + path.dir

				if (point > path.size) then
					log(id, "   .  .")
					patrol_routine.line_dir = -1
					point = path.size - 1
				end

				if (point < 1) then
					log(id, "   .  .")
					patrol_routine.line_dir = 1
					point = 2
				end

			elseif (path.style == "once") then
				point = point + path.dir

				if (point > path.size) then
					log(id, "   .  .")
					Humans[id].patrol_routine = NONE
					Humans[id].patrol_status = 0
					Humans[id].waited = false
					Humans[id].wait_start = 0
calls.leave("b_patrol.think",id)
					return 2
				end

			end

			log(id, " . Point", point)
			x = path.pts[point].x
			y = path.pts[point].y
			z = path.pts[point].z

			if (path.radius > 0.5) then
				local x1, y1, z1 = service.randomPointAroundPoint(x, y, z, path.radius)
				x = x1
				y = y1
				z = z1
				Humans[id].app = { x = x1, y = y1, z = z1 }
				Humans[id].point_try = 1
			end

		elseif ((dist >= 2) and (path.radius > 0.5)) then
			log(id, "  ,     -      .   : ", human.point_try)
			Humans[id].point_try = Humans[id].point_try + 1

			if (Humans[id].point_try > 3) then
				log(id, "  .    -.")
				local x1, y1, z1 = service.randomPointAroundPoint(x, y, z, path.radius)
				x = x1
				y = y1
				z = z1
				Humans[id].app = { x = x1, y = y1, z = z1 }
				Humans[id].point_try = 1
			end

		end
-----------------------------------------------------------------------------------------------------------
		if ((path.wait_style == "none") or (Humans[id].waited == true) or (Humans[id].wait_start == -1)) then

			if (Humans[id].waited == true) then 
				Humans[id].waited = false
				log(id, ".    .")
			end
--			local lx, ly, lz = service.pointAlongPointToPersonLine(x, y, z, id, b_soldier.selectMoveDistFromStrategy(strategy))
			addSmartMove(id, path.mode, x, y, z, 1)
			Humans[id].patrol_status = point
			Humans[id].moveonly = true
			Humans[id].attacked = false
calls.leave("b_patrol.think",id)
			return 1
		elseif ((path.wait_time < 5) or (isGameInRT())) then
			local check_1_sec = time - Humans[id].wait_start - Humans[id].wait_elapsed
			local finish = Humans[id].wait_start + path.wait_time

			if (finish <= time) then
				Humans[id].wait_start = -1
				Humans[id].waited = true
				log(id, " ")
			elseif (check_1_sec >= 1) then
				Humans[id].wait_elapsed = Humans[id].wait_elapsed + 1
				local seconds_left = path.wait_time - Humans[id].wait_elapsed
				log(id, ". :", seconds_left, ".")
			elseif (check_1_sec < 1) then
				log(id, "  ,     .      .     ,     .")
			end

		elseif ((path.wait_time >= 5) and not(isGameInRT())) then
			Humans[id].wait_start = -1
			Humans[id].waited = true
			log(id, " .    5 .")
calls.leave("b_patrol.think",id)
			return 0
		end
calls.leave("b_patrol.think",id)
		return 2
	end,
}